/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity.listener;

import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.shared.listeners.LoginProfileEvent;
import net.skinsrestorer.shared.listeners.LoginProfileListener;
import net.skinsrestorer.velocity.SkinsRestorer;

public class GameProfileRequest
extends LoginProfileListener {
    private final SkinsRestorer plugin;

    @Subscribe
    public EventTask onGameProfileRequest(GameProfileRequestEvent event) {
        LoginProfileEvent wrapped = this.wrap(event);
        if (this.handleSync(wrapped)) {
            return null;
        }
        return EventTask.async(() -> this.handleAsync(wrapped).ifPresent(name -> {
            try {
                event.setGameProfile(this.plugin.getSkinApplierVelocity().updateProfileSkin(event.getGameProfile(), (String)name));
            }
            catch (SkinRequestException e) {
                this.plugin.getSrLogger().debug(e);
            }
        }));
    }

    private LoginProfileEvent wrap(final GameProfileRequestEvent event) {
        return new LoginProfileEvent(){

            @Override
            public boolean isOnline() {
                return event.isOnlineMode();
            }

            @Override
            public String getPlayerName() {
                return event.getUsername();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
    }

    public GameProfileRequest(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }
}

